-- new script file

local waveTown = {}
local mission = {}

function OnAfterSceneLoaded(self)
  self:AddTriggerTarget("attTown")
end

function OnThink(self)
  if not self.initialized then
    self.initialized = true
    
    if not self.loaded then
      self.counter = 0
      self.baseCount = 100 * Citadels.GetPlayer(0):GetDifficultyCoef()
      self.active = false
    end
	  
    mission.enemy = Citadels.GetPlayer(1)
    self.attPoint1 = Game:GetEntity('gateP0-position'):GetPosition()
    self.attPoint2 = Game:GetEntity('thallP0-position'):GetPosition()
  end
  
  if self.active then
    if self.counter > 0 then
      UpgradeWave(self)
    end
    InitializeWave(self)
    GenerateWaveAI(self)
    self.counter = self.counter + 1
    self.active = false
  end  
end

function UpgradeWave(self)
  self.baseCount = self.baseCount + 20
end

function InitializeWave(self)
  waveTown['unit_L_archer_L1'] = self.baseCount * 0.08
  waveTown['unit_L_archer_L2'] = self.baseCount * 0.04
  waveTown['unit_L_fman_L2'] = self.baseCount * 0.06
  waveTown['unit_L_rider_L1'] = self.baseCount * 0.04
  waveTown['unit_L_catapult_L1'] = self.baseCount * 0.02
  --waveTown['unit_L_ram_L1'] = 4
end

function GenerateWaveAI(self)
  for prefab,ammount in pairs(waveTown) do
    mission.enemy:AttackGroupAdd(prefab, ammount)
  end
  mission.enemy:AttackGroupSetModeToSpawn() -- units will be spawned ( not trainded ) around rallypoint
  mission.enemy:AttackGroupAllowedTargetIndex(0) --attack only at player index 0 - human player
  mission.enemy:AttackGroupAddWayPoints(self.attPoint1)
  mission.enemy:AttackGroupAddWayPoints(self.attPoint2)
  mission.enemy:AttackGroupCommit(1, self:GetPosition(),20)
  mission.enemy:AttackGroupMaxWaitTimeForUnitsCreation(20)
end

function OnTrigger(self, source, target)
  if target == "attTown" then
    self.active = true
  end
end

function OnSerialize(self, ar)
  if (ar:IsLoading()) and Citadels.GetLoadGameRunning() then
    self.loaded = true
    self.counter = ar:Read()
    self.baseCount = ar:Read()
    self.active = ar:Read()
  elseif (ar:IsSaving()) then
    ar:Write(self.counter)
    ar:Write(self.baseCount)
    ar:Write(self.active)
  end
end

--[[
function AttackWave(self)
  key = "attTown_"
  for k,v in pairs(waveTown) do
    for i=1,v,1 do
      name = key..i
      unitPos = mission.enemy:GetFreePosition(self:GetPosition(), 3500, 200)
      mission.enemy:createUnit(unitPos, 1, 2, k, name)
    end
  end
  Debug:Log("Wave Town generated")
  mission.enemy:Deselect()
  mission.enemy:SelectUnitsByName(key..'*')
  mission.enemy:SetAggressive()
  mission.enemy:Move(self.attackPoint)
end
]]--
